/*jshint esversion: 6 */

define([
    "lib/dev/config",
	"src/utils", "lodash", "immutable",
	"lib/tasks/dofs", "lib/dev", "src/math/Mat3",
	"lib/tasks/internal"
	],
function(
	config,
    utils, lodash, immutable,
	dofs, dev, mat3,
	internal
) {

"use strict";


/*============================================================================
	Helpers
============================================================================*/

function puppetLeaves (puppet) {
	var layer = puppet.getWarperLayer(),
		tree = layer.getHandleTreeArray(),
		aIsLeaf = tree.getIsLeafArray();

	return function (_, ref) {
		return aIsLeaf[ref];
	};
}

// Get handle frames relative to Puppet frame.
// Returns array of objects with matrix and type.
function getHandleFrames (puppet, mat_Puppet0) {
	var layer = puppet.getWarperLayer(),
		tree = layer.getHandleTreeArray(),
		path = internal.getKeyPath(layer, "value"),
		lomNow = path.layer.tomPrev.getIn(path.key);

	return internal.gatherHandleFrames(tree, lomNow, mat_Puppet0);
}

// Get handle frames relative to Puppet frame.
// Returns array of objects with matrix and type.
function getHandleFramesOld (puppet, mat_Puppet0) {
	var layer = puppet.getWarperLayer(),
		tree = layer.getHandleTreeArray(),
		path = internal.getKeyPath(layer, "value"),
		lomNow = path.layer.tomNow.getIn(path.key);

	return internal.gatherHandleFrames(tree, lomNow, mat_Puppet0);
}

/*============================================================================
	API
============================================================================*/

var puppet = config.MutableTree.enabled ? {

	getHandleFrames,

	// Get _leaf_ handle frames relative to Puppet frame.
	// Returns array of objects with matrix and type.
	getLeafFrames (puppet, mat_Puppet0) {
		var aPuppetFrames = getHandleFrames(puppet, mat_Puppet0);
		return aPuppetFrames.filter(puppetLeaves(puppet));
	},

	// Set handle frames relative to Puppet frame.
	// Expects array of objects with matrix and type.
	setHandleFrames (puppet, aFrames) {
		var layer = puppet.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			path = internal.getKeyPath(layer, "value"),
			lomNow = path.layer.tomNow.getIn(path.key);

		internal.scatterHandleFrames(tree, aFrames, lomNow);
	}
} :
{// old way: to be removed

	getHandleFrames : getHandleFramesOld,

	// Get _leaf_ handle frames relative to Puppet frame.
	// Returns array of objects with matrix and type.
	getLeafFrames (puppet, mat_Puppet0) {
		var aPuppetFrames = getHandleFramesOld(puppet, mat_Puppet0);
		return aPuppetFrames.filter(puppetLeaves(puppet));
	},

	// Set handle frames relative to Puppet frame.
	// Expects array of objects with matrix and type.
	setHandleFrames (puppet, aFrames) {
		var layer = puppet.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			path = internal.getKeyPath(layer, "value"),
			lomNow = path.layer.tomNow.getIn(path.key);

		var lomNext = internal.scatterHandleFrames(tree, aFrames, lomNow);
		path.layer.tomNext = path.layer.tomNext.setIn(path.key, lomNext);
	}
};

return puppet;

}); // end define


